/**
 * this is the main class of the GUI
 * responsible to show everything
 */
package gui;
import gui.menus.view.*;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

/**
 * @author Andrea
 */
public class MainFrame extends JFrame
{
	static final long serialVersionUID = 1l;
	private MainFrameMenuBar menuBar;
	private SimulationPanel statePanel;
	private ServicePanel availableServicePanel;
	private JSplitPane leftSplitPane;
	private GraphViewerPanel graphPanel;
	private JSplitPane splitPane;
	static MainFrame mainFrame;
	private Properties applicationProps = new Properties();

	public MainFrame()
	{
		/**
		 * 1: Frame creation
		 */
		super();
		initialize();
		mainFrame = this;
		leftSplitPane.setDividerLocation((int)(mainFrame.getContentPane().getHeight()/3)*2);
	}
	void initialize()
	{
		//load properties
		FileInputStream in;
		try {
			in = new FileInputStream("symphony.conf");
			applicationProps.load(in);
			in.close();
			String orchestrator_prop=applicationProps.getProperty("orchestrator");
			if(orchestrator_prop.equals("standard"))
				GenericLoader.setOrchestrator(GenericLoader.ORCHESTRATOR_STANDARD);
			else if(orchestrator_prop.equals("plus"))
				GenericLoader.setOrchestrator(GenericLoader.ORCHESTRATOR_PLUS);

		} catch (FileNotFoundException e1) {
			applicationProps.put("orchestrator", "standard");
			applicationProps.put("targetDirectory", ".");
			applicationProps.put("availableDirectory", ".");
			FileOutputStream out;
			try {
				out = new FileOutputStream("symphony.conf");
				applicationProps.store(out, "");
				out.close();
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}			
		} catch (IOException e) {
			e.printStackTrace();
		}


		/**
		 * 2: Frame creation (follows from above). 
		 * 		- title defining 
		 * 		- size defining
		 * 		- closing defining
		 */
		this.setTitle("Symphony 2.0");
		this.setLocation(0,0);
		this.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height-30);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		menuBar = new MainFrameMenuBar();
		this.setJMenuBar(menuBar);
		
		statePanel = new SimulationPanel();
		graphPanel = new GraphViewerPanel();
		availableServicePanel = new ServicePanel();
		
		leftSplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, availableServicePanel,statePanel);
		leftSplitPane.setDividerLocation(500);

		/**
		 * creating the JSplitPane
		 */
		splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, leftSplitPane, graphPanel);
		splitPane.setOneTouchExpandable(true);
		
		this.add(splitPane);

		this.setVisible(true);

	}
	
	public static MainFrame getInstance()
	{
		if(mainFrame == null) return new MainFrame();
		else return mainFrame;
	}
	
	public GraphViewerPanel getGraphViewerPanel()
	{
		return graphPanel;
	}
	public ServicePanel getAvServPanel()
	{
		return availableServicePanel;
	}
	public SimulationPanel getStateDescriptionPanel()
	{
		return statePanel;
	}
	
	public void showTarget()
	{
		((TargetViewItem)menuBar.getViewMenu().getTargetItem()).showTarget();
	}
}
